/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.worlds.together.tag.v3;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2348;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3503;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import org.betterx.worlds.together.levelgen.WorldGenUtil;
import org.betterx.worlds.together.mixin.common.DiggerItemAccessor;
import org.betterx.worlds.together.tag.v3.CommonBiomeTags;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;
import org.betterx.worlds.together.tag.v3.CommonItemTags;
import org.betterx.worlds.together.tag.v3.MineableTags;
import org.betterx.worlds.together.tag.v3.TagRegistry;
import org.betterx.worlds.together.tag.v3.ToolTags;
import org.betterx.worlds.together.world.event.WorldEventsImpl;
import org.jetbrains.annotations.ApiStatus;

public class TagManager {
    private static final Map<String, TagRegistry<?>> TYPES = Maps.newHashMap();
    public static TagRegistry.RegistryBacked<class_2248> BLOCKS = TagManager.registerType(class_2378.field_11146);
    public static TagRegistry.Items ITEMS = TagManager.registerItem();
    public static TagRegistry.Biomes BIOMES = TagManager.registerBiome();

    public static <T> TagRegistry.RegistryBacked<T> registerType(class_2348<T> registry) {
        TagRegistry.RegistryBacked type = new TagRegistry.RegistryBacked(registry);
        return (TagRegistry.RegistryBacked)TYPES.computeIfAbsent(type.directory, dir -> type);
    }

    public static TagRegistry.Items registerItem() {
        TagRegistry.Items type = new TagRegistry.Items();
        return (TagRegistry.Items)TYPES.computeIfAbsent(type.directory, dir -> type);
    }

    public static <T> TagRegistry.Simple<T> registerType(class_2378<T> registry, String directory) {
        return TagManager.registerType(registry.method_30517(), directory, o -> registry.method_10221(o));
    }

    public static <T> TagRegistry.Simple<T> registerType(class_5321<? extends class_2378<T>> registry, String directory, Function<T, class_2960> locationProvider) {
        return (TagRegistry.Simple)TYPES.computeIfAbsent(directory, dir -> new TagRegistry.Simple(registry, (String)dir, locationProvider));
    }

    static TagRegistry.Biomes registerBiome() {
        return (TagRegistry.Biomes)TYPES.computeIfAbsent("tags/worldgen/biome", dir -> new TagRegistry.Biomes((String)dir, b -> WorldGenUtil.getBiomeID(b)));
    }

    public static <T> TagRegistry.UnTyped<T> registerType(class_5321<? extends class_2378<T>> registry, String directory) {
        return (TagRegistry.UnTyped)TYPES.computeIfAbsent(directory, dir -> new TagRegistry.UnTyped(registry, (String)dir));
    }

    @ApiStatus.Internal
    public static void ensureStaticallyLoaded() {
        CommonItemTags.prepareTags();
        CommonBlockTags.prepareTags();
        CommonBiomeTags.prepareTags();
        MineableTags.prepareTags();
        ToolTags.prepareTags();
    }

    @ApiStatus.Internal
    public static <T> Map<class_2960, List<class_3503.class_5145>> apply(String directory, Map<class_2960, List<class_3503.class_5145>> tagsMap) {
        WorldEventsImpl.BEFORE_ADDING_TAGS.emit(e -> e.apply(directory, tagsMap));
        TagRegistry<?> type = TYPES.get(directory);
        if (type != null) {
            type.apply(tagsMap);
        }
        return tagsMap;
    }

    public static boolean isToolWithMineableTag(class_1799 stack, class_6862<class_2248> tag) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof DiggerItemAccessor) {
            DiggerItemAccessor dig = (DiggerItemAccessor)class_17922;
            return dig.bclib_getBlockTag() == tag;
        }
        return false;
    }
}

